/*
 * Decompiled with CFR 0.152.
 */
package fuzs.barteringstation.world.entity.monster.piglin;

import fuzs.barteringstation.BarteringStation;
import fuzs.barteringstation.config.ServerConfig;
import fuzs.barteringstation.core.ModServices;
import fuzs.barteringstation.init.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.item.ItemStack;

public class PiglinAiHelper
extends PiglinAi {
    public static boolean mobInteract(Piglin piglin, ItemStack stack, BlockPos source) {
        if (PiglinAiHelper.m_34909_((Piglin)piglin, (ItemStack)stack)) {
            ItemStack currencyStack = stack.m_41620_(1);
            PiglinAiHelper.holdInOffhand(piglin, currencyStack);
            PiglinAiHelper.admireGoldItem((LivingEntity)piglin);
            PiglinAiHelper.stopWalking(piglin);
            ModRegistry.BARTERING_STATION_CAPABILITY.maybeGet((Object)piglin).ifPresent(capability -> capability.setBarteringStationPos(source));
            return true;
        }
        return false;
    }

    private static void holdInOffhand(Piglin p_34933_, ItemStack p_34934_) {
        if (PiglinAiHelper.isHoldingItemInOffHand(p_34933_)) {
            p_34933_.m_19983_(p_34933_.m_21120_(InteractionHand.OFF_HAND));
        }
        PiglinAiHelper.holdInOffHand(p_34933_, p_34934_);
    }

    private static boolean isHoldingItemInOffHand(Piglin p_35027_) {
        return !p_35027_.m_21206_().m_41619_();
    }

    private static void holdInOffHand(Piglin piglin, ItemStack stack) {
        if (ModServices.ABSTRACTIONS.isPiglinCurrency(stack)) {
            piglin.m_8061_(EquipmentSlot.OFFHAND, stack);
            piglin.m_21508_(EquipmentSlot.OFFHAND);
        } else {
            PiglinAiHelper.setItemSlotAndDropWhenKilled(piglin, EquipmentSlot.OFFHAND, stack);
        }
    }

    private static void setItemSlotAndDropWhenKilled(Piglin piglin, EquipmentSlot p_21469_, ItemStack p_21470_) {
        piglin.m_8061_(p_21469_, p_21470_);
        piglin.m_21508_(p_21469_);
        piglin.m_21530_();
    }

    private static void admireGoldItem(LivingEntity p_34939_) {
        p_34939_.m_6274_().m_21882_(MemoryModuleType.f_26336_, (Object)true, (long)(((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay / 2));
    }

    private static void stopWalking(Piglin p_35007_) {
        p_35007_.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        p_35007_.m_21573_().m_26573_();
    }
}

